import 'package:flutter/material.dart';
import 'package:dartz/dartz.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:mobile/injection/injection.dart';
import 'package:mobile/core/errors/failures.dart';
import 'package:mobile/core/usecases/usecase.dart';
import 'package:mobile/features/profile/domain/usecases/get_kyc_status_usecase.dart';

class KycGuard extends StatelessWidget {
  final Widget child;

  const KycGuard({Key? key, required this.child}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<Either<Failure, bool>>(
      future: getIt<GetKycStatusUseCase>().call(NoParams()),
      builder: (context, snapshot) {
        if (!snapshot.hasData) {
          return const Center(child: CircularProgressIndicator());
        }
        return snapshot.data!.fold(
          (failure) => Center(child: Text(failure.message)),
          (hasKyc) => hasKyc
              ? child
              : const Center(
                  child: Padding(
                    padding: EdgeInsets.all(16),
                    child: Text(
                      'KYC required to access staking. Please complete your KYC.',
                      textAlign: TextAlign.center,
                    ),
                  ),
                ),
        );
      },
    );
  }
}
